definition module windowcontrols

//	Clean Object I/O library, version 1.0.1

//	Operations to open, close, and reposition controls in windows.

import	windowhandle
from	StdPSt import PSt, IOSt


opencontrols		:: .ls ![WElementHandle .ls .ps] !(WindowStateHandle .ps) !*OSToolbox -> (!WindowStateHandle .ps,!*OSToolbox)
/*	opencontrols adds the given controls to the given window.
	It is assumed that no Id conflicts can arise with the current set of controls.
*/

opencompoundcontrols:: !Id .ls ![WElementHandle .ls .ps] !(WindowStateHandle .ps) !*OSToolbox -> (!Bool,!WindowStateHandle .ps,!*OSToolbox)
/*	opencompoundcontrols adds the given controls to the compound control of the given window.
	It is assumed that no Id conflicts can arise with the current set of controls.
	The Boolean result is True iff the compound control could be found.
*/

closecontrols		:: ![Id] !Bool !(WindowStateHandle .ps) !*OSToolbox -> (![Id],!WindowStateHandle .ps,!*OSToolbox)
/*	closecontrols removes the indicated controls from the window.
	The result Ids are the Ids of receiver(2)s that have been removed.
	If the Boolean argument is True then the layout of the remaining controls will be recalculated.
*/

setcontrolpos		:: !Id !ItemPos !(WindowStateHandle .ps) !*OSToolbox -> (!Bool,!WindowStateHandle .ps,!*OSToolbox)
/*	setcontrolpos sets the position of the indicated control to the new position.
	The Boolean result is True iff the control could be found and the new position is legal. 
*/
